
#define QueueLen 4096

typedef struct
{
  pthread_mutex_t mutex;
  int tail;
  int head;
  int count;
  int size;
  int wrcount;
  unsigned char data[QueueLen];
}tQueue;

#define QueueInitializer {PTHREAD_MUTEX_INITIALIZER, 0, 0, 0, QueueLen, 0, {0}}

void queueInit(tQueue *q);
int queueCount(tQueue *q);
int queueRoom(tQueue *q);
int queueEmpty(tQueue *q);
int queueFull(tQueue *q);
void queueFlush(tQueue *q);
void queueRewind(tQueue *q, unsigned count);
int queueRead(tQueue *q, unsigned char *buf, unsigned count);
int queueWrite(tQueue *q, unsigned char *buf, unsigned count);
