extern FILE *errfp;
extern int debugLevel;

extern pthread_mutex_t log_mutex;

#define LogLock(lvl) \
  do { if (debugLevel >= lvl) pthread_mutex_lock(&log_mutex); } while(0)

#define LogPrintf(lvl,fmt,args...) \
  do { if (debugLevel >= lvl) fprintf(errfp,fmt , ## args); } while (0)

#define LogUnlock(lvl) \
  do { if (debugLevel >= lvl) pthread_mutex_unlock(&log_mutex); } while(0)
      

#define Log(lvl,fmt,args...) \
  do { \
      if (debugLevel >= lvl) \
       { \
        struct timeval tv; \
        gettimeofday(&tv,NULL); \
        pthread_mutex_lock(&log_mutex); \
        fprintf(errfp,"%ld.%06ld ",(long)tv.tv_sec,(long)tv.tv_usec); \
        fprintf(errfp,fmt , ## args); \
        pthread_mutex_unlock(&log_mutex); \
       } \
     }while (0)

#define NumElements(a) ((int)((sizeof a)/(sizeof a[0])))

#define Trace() fprintf(stderr,"%s:%d\n",__FILE__,__LINE__)  
  
#define ErrAbort(expression) \
    do { \
      int status = expression; \
      Log(0,"Error %d: %s at %s:%d: " #expression "\n", \
                    status, strerror(status), \
                    __FILE__,__LINE__); \
          abort(); \
        } \
    } while (0)

  
#define ErrnoAbort(expression) \
    do { \
      int status = expression; \
      if (status) \
        { \
          Log(0,"Error %d: %s at %s:%d: " #expression "\n", \
                    errno, strerror(errno), \
                    __FILE__,__LINE__); \
          abort(); \
        } \
    } while (0)

long timeDeltaMS(struct timeval *tNow, struct timeval *tLast);

