#ifndef CYGONCE_ETHERIO_H
#define CYGONCE_ETHERIO_H

//// This file contains the user-level visible I/O interfaces

#include <pkgconf/hal.h>
#include <cyg/infra/cyg_type.h>
#if defined(CYGPKG_IO)
#include <cyg/io/config_keys.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif
// This filter function uses a buffer, length and port (for future hardware
// compatability) to remove some traffic that should not be passed on
// to TCP/IP stack
    typedef cyg_uint32 (*filter_func)(void *, cyg_uint32 len, cyg_uint32 port);

#define CONFIG_MAGIC 0xDBC0FFEE

    typedef struct {
        cyg_uint8    mac_address[6];
        cyg_uint16   protocol;
        cyg_uint32   flags;
        cyg_uint32   magic;
        cyg_uint16   version;
        cyg_uint16   size;
        filter_func  func_ptr;
    } cyg_ether_info_t;

// physical link configuration flags
#define CYG_ETHER_FLAGS_DISABLE_AUTONEG     0x0001
#define CYG_ETHER_FLAGS_DISABLE_100M        0x0002
#define CYG_ETHER_FLAGS_DISABLE_FULLDUPLEX  0x0004
// driver configuration flags
#define CYG_ETHER_FLAGS_RD_NONBLOCK 0x00010000
#define CYG_ETHER_FLAGS_WR_NONBLOCK 0x00020000
#define CYG_ETHER_FLAGS_PROMISCUOUS 0x00040000

// link status flags
#define CYG_ETHER_LINK_STATUS_UP          0x1
#define CYG_ETHER_LINK_STATUS_FULL_DUPLEX 0x2
#define CYG_ETHER_LINK_STATUS_100M        0x4

//----------------------------------------------------------------------
// Buffer structure passed back and forth between userspace and
// driver to avoid copying data.
//
// data is first so that we can typecast back/forth between BDMA
// data buffer pointers and pointers to this struct.  This means
// that it's important not to write off the end of the data area.

#define MAX_ETH_FRAME_SIZE 1520

    typedef struct tEthBufferTag {
        unsigned char data[MAX_ETH_FRAME_SIZE+8];
        unsigned length;
        unsigned userData;
        struct tEthBufferTag *next;
        struct tEthBufferTag *prev;
    }tEthBuffer;

    typedef struct tConfigMacFwd_tag {
        char mac[6];
        char port_mask;
        char addr;
    } tConfigMacFwd;

// Put config keys here in case they don't get added to global config_keys.h

#if !defined(CYG_IO_GET_CONFIG_ETHER_INFO)

#define CYG_IO_GET_CONFIG_ETHER_INFO     0x0401
#define CYG_IO_GET_CONFIG_ETHER_LINK_STATUS    0x0402

#define CYG_IO_SET_CONFIG_ETHER_INFO     0x0481
#define CYG_IO_SET_CONFIG_MAC_FWD        0x0482
#define CYG_IO_SET_CONFIG_SPEC_TAG_MODE  0x0483
#define CYG_IO_SET_CONFIG_PORT_MACS  	 0x0484

#define CYG_IO_GET_CONFIG_ETHER_ALLOC_BUFFER 0x0410
#define CYG_IO_GET_CONFIG_ETHER_FREE_BUFFER  0x0411
#define CYG_IO_GET_CONFIG_ETHER_SEND_BUFFER  0x0412
#define CYG_IO_GET_CONFIG_ETHER_RECV_BUFFER  0x0413

#endif

#ifdef __cplusplus
}
#endif


#endif
