/*********************************************************************
 *  iic.h
 *
 *  Include file for iic.c
 *********************************************************************/

/*  Macros which define addresses (decimal) and sizes (bytes) of IIC variables */
#define MAC_ADDRESS_ADDR        0
#define BOARD_REV_ADDR          8
#define MODEL_NUMBER_ADDR       12
#define IP_ADDRESS_ADDR         16
#define NETMASK_ADDR            20
#define GATEWAY_ADDR            24
#define PASSWORD_ADDR           32
#define AUTH_METHOD_ADDR        48
#define SERVICE_ENABLE_ADDR     49
#define TIMEOUT_ADDR            50
#define TELNET_TIMEOUT_ADDR     52
#define SERNUM_PREFIX_ADDR      56
#define SERNUM_ADDR             58
#define APP_ENABLE_KEY_ADDR     60
#define PORT_MAC_INFO_ADDR		62
#ifdef CYGSEM_HAL_USER_PASSWORD_SUPPORT
#define USER_PASSWD_ADDR        66
#endif

#define MAC_ADDRESS_SIZE        6
#define BOARD_REV_SIZE          4
#define MODEL_NUMBER_SIZE       4
#define IP_ADDRESS_SIZE         4
#define NETMASK_SIZE            4
#define GATEWAY_SIZE            4
#define PASSWORD_SIZE           16
#define AUTH_METHOD_SIZE        1
#define SERVICE_ENABLE_SIZE     1
#define TIMEOUT_SIZE            1
#define TELNET_TIMEOUT_SIZE     4
#define SERNUM_PREFIX_SIZE      2
#define SERNUM_SIZE             2
#define APP_ENABLE_KEY_SIZE     1
#define PORT_MAC_INFO_SIZE		4
#ifdef CYGSEM_HAL_USER_PASSWORD_SUPPORT
#define USER_PASSWD_SIZE        16
#endif

/* Byte map of port mac info bytes (address:62) */
#define NUM_OF_PORT_MACS_ADDR	0
#define START_PORT_MAC_ADDR		1

/* Size of port mac info bytes (address:62) */
#define NUM_OF_PORT_MACS_SIZE	1
#define START_PORT_MAC_SIZE		3

/* Bit map of service enable byte (address: 49) */
#define SERVICE_TELNET          0x01
#define SERVICE_SECURE_DATA     0x02
#define SERVICE_SNMP            0x04
#define SERVICE_SECURE_CONFIG   0x08
// Inverted sense of stored SERVICE_DHCP bit to maintain forward compatibility
#define SERVICE_DHCP			0x10
#define SERVICE_SECURE_MONITOR  0x20
//
// Bit 7 (0x80) can never be used for a service enable because of a
// bug recently introduced into the production test which was setting
// bits 3-7 to 1 instead of 0 (older versions of production test set
// those bits to 0).  This resulted in unpredictable behavior when
// upgrading firmware to a version that uses a new service enable bit.
//
// The masks below are used to 1) detect when service enable byte is
// broken due to buggy production test software and 2) clear bits 4-7
// when it is detected that it's broken
#define SERVICE_BYTE_IS_BROKEN  0x80
#define SERVICE_BYTE_FIX_MASK 0x05

/*  Prototypes */
void iicInit(void);
void iicRead(int slave_addr, int addr, void *p, int count);
void iicWrite(int slave_addr, int addr, void *p, int count);
void iicReadRt(int slave_addr, int addr, void *p, int count);
void iicDelay(void);
void getMacAddress(unsigned char *p);
void putMacAddress(unsigned char *p);
void getBoardRev(unsigned long *p);
void putBoardRev(unsigned long p);
void getModelNumber(unsigned long *m);
void putModelNumber(unsigned long m);
void putIpInfo(unsigned long ipAddr, unsigned long netMask, unsigned long gateway);
void getIpInfo(unsigned long *ipAddr, unsigned long *netMask, unsigned long *gateway);
void getPassword(char *p);
void putPassword(char *p);
void getAuthMethod(unsigned char *m);
void putAuthMethod(unsigned char m);
void getTelnetEnable(unsigned char *p);
void putTelnetEnable(unsigned char m);
void getSecureDataEnable(unsigned char *p);
void putSecureDataEnable(unsigned char m);
void getSecureConfigEnable(unsigned char *p);
void putSecureConfigEnable(unsigned char m);
void getSecureMonitorEnable(unsigned char *p);
void putSecureMonitorEnable(unsigned char m);
void getSnmpEnable(unsigned char *p);
void putSnmpEnable(unsigned char m);
void putRedbootDelay(unsigned char t);
void getRedbootDelay(unsigned char *p);
void getTelnetTimeout(unsigned long *p);
void putTelnetTimeout(unsigned long t);
void putSerNumPrefix(unsigned short p);
void getSerNumPrefix(unsigned short *p);
void putSerNum(unsigned short p);
void getSerNum(unsigned short *p);
void getAppEnableKey(unsigned char *p);
void getDhcpEnable(unsigned char *p);
void putDhcpEnable(unsigned char m);
void getNumOfPortMacs(unsigned char *p);
void putNumOfPortMacs(unsigned char m);
void getStartingPortMac(unsigned char *p);
void putStartingPortMac(unsigned char *m);
#ifdef CYGSEM_HAL_USER_PASSWORD_SUPPORT
void getUserPasswd(char *p);
void putUserPasswd(char *p);
#endif

void getIpInfoRt(unsigned long *ipAddr, unsigned long *netMask, unsigned long *gateway);
void putIpInfoRt(unsigned long ipAddr, unsigned long netMask, unsigned long gateway);
void getPasswordRt(char *p);
void putPasswordRt(char *p);
void putAuthMethodRt(unsigned char m);
void getTelnetEnableRt(unsigned char *p);
void putTelnetEnableRt(unsigned char m);
void getSecureConfigEnableRt(unsigned char *p);
void putSecureConfigEnableRt(unsigned char m);
void getSecureDataEnableRt(unsigned char *p);
void putSecureDataEnableRt(unsigned char m);
void getSecureMonitorEnableRt(unsigned char *p);
void putSecureMonitorEnableRt(unsigned char m);
void getSnmpEnableRt(unsigned char *p);
void putSnmpEnableRt(unsigned char m);
void getRedbootDelayRt(unsigned char *p);
void putRedbootDelayRt(unsigned char t);
void getTelnetTimeoutRt(unsigned long *p);
void putTelnetTimeoutRt(unsigned long t);
void getDhcpEnableRt(unsigned char *p);
void putDhcpEnableRt(unsigned char p);
void getNumOfPortMacsRt(unsigned char *p);
void putNumOfPortMacsRt(unsigned char m);
void getStartingPortMacRt(unsigned char *p);
void putStartingPortMacRt(unsigned char *m);
#ifdef CYGSEM_HAL_USER_PASSWORD_SUPPORT
void getUserPasswdRt(char *p);
void putUserPasswdRt(char *p);
#endif

void restoreFactoryDefault(void);
