#!/usr/bin/python

# a simple program to send frames and verify replies to/from a DeviceMaster
# that's running the netecho program.
#
# Requires AF_PACKET socket support.  AFAIK, that's only available under
# Linux with Python 2.0 or later.

import sys
import string
import struct
import time
import random
from socket import *

def macAddrStr(s):
    r = ""
    for c in s:
        r = r + "%02x:" % ord(c)
    return r[:-1]

if len(sys.argv) != 3:
    raise "Usage: %s ethX xx:xx:xx:xx:xx:xx"

proto = 0x5432
interface = sys.argv[1]
destMacStr = sys.argv[2]

print "creating socket:",
s = socket(AF_PACKET, SOCK_RAW, proto)
print s

print "binding socket:",
s.bind((interface,proto,0,0))
print "done"

txData = "".join([chr(x & 0xff) for x in range(1600)])

ifName,ifProto,pktType,hwType,srcAddr = s.getsockname()

hwAddrStr = string.join(["%02x"%ord(b) for b in srcAddr],":")

print " src addr: name=%s, proto=%04x, pkttype=%d, hwtype=%d, addr=%s" % (
             ifName,      ifProto,     pktType,    hwType,  macAddrStr(srcAddr))

dstAddr = "".join([chr(int(x,16)) for x in destMacStr.split(":")])

print "dest addr: %s" % macAddrStr(dstAddr)

ethData = "here is some data for an ethernet packet"

txHeader = struct.pack("!6s6sh",dstAddr,srcAddr,proto)

while 1:
    txFrame = txHeader + txData[:random.randrange(64,1400)]
    
    print "tx [%d]" % len(txFrame)
    s.send(txFrame)

    rxFrame = s.recv(2048)
    print "rx [%d]" % len(rxFrame)
    
    if len(rxFrame) != len(rxFrame):
	raise "Rx/Tx length mismatch"
    
    if rxFrame[14:] != txFrame[14:]:
	raise "Rx/Tx data mismatch"
    
    time.sleep(0.5)

