#ifndef CYGONCE_NSERIALIO_H
#define CYGONCE_NSERIALIO_H
// ====================================================================
//
//      serialio.h
//
//      Device I/O 
//
// ====================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
// ====================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   gthomas
// Contributors:        gthomas
// Date:        1999-02-04
// Purpose:     Special support for serial I/O devices
// Description:
//
//####DESCRIPTIONEND####
//
// ====================================================================

// This file contains the user-level visible I/O interfaces

#include <pkgconf/hal.h>
#include <cyg/infra/cyg_type.h>
#include <cyg/io/config_keys.h>

#ifdef __cplusplus
extern "C" {
#endif

// an extra error value for serial read

#define EINTERCHARTIMEOUT 1000  
#define EEOL 1001  
  
// Supported baud rates
typedef enum {
    CYGNUM_SERIAL_BAUD_50 = 1,
    CYGNUM_SERIAL_BAUD_75,
    CYGNUM_SERIAL_BAUD_110,
    CYGNUM_SERIAL_BAUD_134_5,
    CYGNUM_SERIAL_BAUD_150,
    CYGNUM_SERIAL_BAUD_200,
    CYGNUM_SERIAL_BAUD_300,
    CYGNUM_SERIAL_BAUD_600,
    CYGNUM_SERIAL_BAUD_1200,
    CYGNUM_SERIAL_BAUD_1800,
    CYGNUM_SERIAL_BAUD_2400,
    CYGNUM_SERIAL_BAUD_3600,
    CYGNUM_SERIAL_BAUD_4800,
    CYGNUM_SERIAL_BAUD_7200,
    CYGNUM_SERIAL_BAUD_9600,
    CYGNUM_SERIAL_BAUD_14400,
    CYGNUM_SERIAL_BAUD_19200,
    CYGNUM_SERIAL_BAUD_38400,
    CYGNUM_SERIAL_BAUD_57600,
    CYGNUM_SERIAL_BAUD_115200,
    CYGNUM_SERIAL_BAUD_230400,
    CYGNUM_SERIAL_BAUD_460800
} cyg_serial_baud_rate_t;
#define CYGNUM_SERIAL_BAUD_MIN CYGNUM_SERIAL_BAUD_50 
#define CYGNUM_SERIAL_BAUD_MAX CYGNUM_SERIAL_BAUD_460800

// Note: two levels of macro are required to get proper expansion.
#define _CYG_SERIAL_BAUD_RATE(n) CYGNUM_SERIAL_BAUD_##n
#define CYG_SERIAL_BAUD_RATE(n) _CYG_SERIAL_BAUD_RATE(n)

// Stop bit selections
typedef enum {
    CYGNUM_SERIAL_STOP_1 = 1,
    CYGNUM_SERIAL_STOP_1_5,
    CYGNUM_SERIAL_STOP_2
} cyg_serial_stop_bits_t;

// Parity modes
typedef enum {
    CYGNUM_SERIAL_PARITY_NONE = 0,
    CYGNUM_SERIAL_PARITY_EVEN,
    CYGNUM_SERIAL_PARITY_ODD,
    CYGNUM_SERIAL_PARITY_MARK,
    CYGNUM_SERIAL_PARITY_SPACE
} cyg_serial_parity_t;

// Word length
typedef enum {
    CYGNUM_SERIAL_WORD_LENGTH_5 = 5,
    CYGNUM_SERIAL_WORD_LENGTH_6,
    CYGNUM_SERIAL_WORD_LENGTH_7,
    CYGNUM_SERIAL_WORD_LENGTH_8
} cyg_serial_word_length_t;

#define RX_CALLBACK_STATUS_PERR  0x80
#define RX_CALLBACK_STATUS_OVER  0x40
#define RX_CALLBACK_STATUS_FRAME 0x20
#define RX_CALLBACK_STATUS_BREAK 0x10
  
  
typedef void cyg_serial_modem_callback_t(void *data, unsigned currentState, unsigned deltaState);
typedef void cyg_serial_rx_callback_t(void *data, unsigned char c, unsigned char status);
  
typedef struct {
    cyg_serial_baud_rate_t   baud;
    cyg_serial_stop_bits_t   stop;
    cyg_serial_parity_t      parity;
    cyg_serial_word_length_t word_length;
    cyg_uint32               flags;
    cyg_uint8                rxflow_xon_char;
    cyg_uint8                rxflow_xoff_char;
    cyg_uint8                txflow_xon_char;
    cyg_uint8                txflow_xoff_char;
    cyg_uint8                interface_mode;
    cyg_uint32               read_timeout;
    cyg_uint32               write_timeout;
    cyg_uint32               inter_char_timeout;
    cyg_serial_modem_callback_t *modem_callback;
    void                        *modem_callback_data;
    cyg_serial_rx_callback_t    *rx_callback;
    void                        *rx_callback_data;
    cyg_uint8                eol1;
    cyg_uint8                eol2;
    cyg_uint32               preRtsHoldTime;
    cyg_uint32               postRtsHoldTime;
} cyg_serial_info_t;

#define CYG_SERIAL_INFO_INIT(_baud,_stop,_parity,_word_length,_flags, _rxxon, _rxxoff, _txxon, _txxoff) \
  { _baud, _stop, _parity, _word_length, _flags, _rxxon, _rxxoff, _txxon, _txxoff}

// Structure used by CYG_IO_GET_CONFIG_SERIAL_BUFINFO
typedef struct {  
  cyg_int32 rx_bufsize;
  cyg_int32 rx_count;
  cyg_int32 tx_bufsize;
  cyg_int32 tx_count;
  cyg_int32 rx_fifo_count;
  cyg_int32 tx_fifo_count;
  cyg_int32 rx_inter_char_timeout_flag;
} cyg_serial_buf_info_t;
  
// Structure used by CYG_IO_GET_CONFIG_SERIAL_ERRORS
typedef struct {
  unsigned rxOverflow;
  unsigned rxParity;
  unsigned rxFraming;
  unsigned rxBreak;
  unsigned fifo;
} cyg_serial_error_count_t;


// Modem control/status line flags

  /* modem status */
#define CYG_SERIAL_MODEM_CTS 0x0001
#define CYG_SERIAL_MODEM_DSR 0x0002
#define CYG_SERIAL_MODEM_RI  0x0004
#define CYG_SERIAL_MODEM_CD  0x0008

#define CYG_SERIAL_MODEM_CTS_DELTA 0x0010
#define CYG_SERIAL_MODEM_DSR_DELTA 0x0020
#define CYG_SERIAL_MODEM_RI_DELTA  0x0040
#define CYG_SERIAL_MODEM_CD_DELTA  0x0080
  /* modem control */
#define CYG_SERIAL_MODEM_DTR  0x0100
#define CYG_SERIAL_MODEM_RTS  0x0200
  /* other status */
#define CYG_SERIAL_MODEM_FLOWTXOFF 0x10000  
  
// Config flags
#define CYG_SERIAL_FLAGS_RTSCTS         0x0001
#define CYG_SERIAL_FLAGS_RTS_RXFLOW     0x0002
#define CYG_SERIAL_FLAGS_CTS_TXFLOW     0x0004
#define CYG_SERIAL_FLAGS_XONXOFF_RXFLOW 0x0008
#define CYG_SERIAL_FLAGS_XONXOFF_TXFLOW 0x0010
#define CYG_SERIAL_FLAGS_RTS_TOGGLE     0x0020
#define CYG_SERIAL_FLAGS_EN_LOOPBACK    0x0040
#define CYG_SERIAL_FLAGS_IGN_NULLS      0x0080  
#define CYG_SERIAL_FLAGS_EOL1            0x0100
#define CYG_SERIAL_FLAGS_EOL2            0x0200
#define CYG_SERIAL_FLAGS_SOFT_RTS_TOGGLE 0x0400
#define CYG_SERIAL_FLAGS_XONXOFF_IXANY   0x0800
  
#define CYG_SERIAL_FLAGS_RD_NONBLOCK       0x10000  
#define CYG_SERIAL_FLAGS_WR_NONBLOCK       0x20000
#define CYG_SERIAL_FLAGS_RD_SEMIBLOCK      0x40000
  
#define CYG_SERIAL_FLAGS_RXFIFO_DISABLE     0x100000  

  
// Default configuration
#define CYG_SERIAL_BAUD_DEFAULT        CYGNUM_SERIAL_BAUD_38400
#define CYG_SERIAL_STOP_DEFAULT        CYGNUM_SERIAL_STOP_1
#define CYG_SERIAL_PARITY_DEFAULT      CYGNUM_SERIAL_PARITY_NONE
#define CYG_SERIAL_WORD_LENGTH_DEFAULT CYGNUM_SERIAL_WORD_LENGTH_8
#define CYG_SERIAL_FLAGS_DEFAULT       0

  
// additional config keys if they aren't in global config_keys.h
  
#if !defined(CYG_IO_GET_CONFIG_SERIAL_TX_START)  
#define CYG_IO_GET_CONFIG_SERIAL_TX_START        0x0106
#define CYG_IO_GET_CONFIG_SERIAL_TX_STOP         0x0107
#define CYG_IO_GET_CONFIG_SERIAL_BUFFER_INFO     0x0111


#define CYG_IO_GET_CONFIG_SERIAL_MODEM           0x0301
#define CYG_IO_GET_CONFIG_SERIAL_ERRORS          0x0302
#define CYG_IO_GET_CONFIG_SERIAL_CLRERRS         0x0303
#define CYG_IO_GET_CONFIG_SERIAL_BREAKON         0x0304
#define CYG_IO_GET_CONFIG_SERIAL_BREAKOFF        0x0305
#define CYG_IO_GET_CONFIG_TX_OVERRIDE            0x0306
#define CYG_IO_GET_CONFIG_SERIAL_SYNC            0x0307
#define CYG_IO_SET_CONFIG_TX_OFF                 0x0308
#define CYG_IO_GET_CONFIG_RESTART_UART           0x0309
#define CYG_IO_SET_CONFIG_SERIAL_DATALOGGING     0x030a

#define CYG_IO_SET_CONFIG_SERIAL_MODEM           0x0381
#define CYG_IO_SET_CONFIG_SERIAL_SCAN_PERIOD     0x0382

#define CYG_IO_SET_CONFIG_SERIAL_WRITE_PRIORITY_BYTE 0x0182

typedef int (*tSerialDataLoggerFuncPtr)(int direction, const cyg_uint8 *buffer, unsigned length);

#endif  
  
#ifdef __cplusplus
}
#endif

#endif  /* CYGONCE_SERIALIO_H */
/* EOF serialio.h */
