#ifndef CYGONCE_HAL_PLF_STUB_H
#define CYGONCE_HAL_PLF_STUB_H

#include <pkgconf/hal.h>

#ifdef CYGDBG_HAL_DEBUG_GDB_INCLUDE_STUBS
#include <cyg/infra/cyg_type.h>         // CYG_UNUSED_PARAM
#include <cyg/hal/arm_stub.h>           // architecture stub support
// Define serial stuff.
externC void cyg_hal_plf_comms_init(void);
#define HAL_STUB_PLATFORM_INIT_SERIAL()       cyg_hal_plf_comms_init()
#define HAL_STUB_PLATFORM_SET_BAUD_RATE(baud) CYG_UNUSED_PARAM(int, (baud))
#define HAL_STUB_PLATFORM_INTERRUPTIBLE       0
#define HAL_STUB_PLATFORM_INIT_BREAK_IRQ()    CYG_EMPTY_STATEMENT
// Stub initializer.
#define HAL_STUB_PLATFORM_INIT()              CYG_EMPTY_STATEMENT
#endif // ifdef CYGDBG_HAL_DEBUG_GDB_INCLUDE_STUBS

// Reset.
externC void hal_rpsh_reset(void);
#define HAL_STUB_PLATFORM_RESET() hal_rpsh_reset()
#define HAL_STUB_PLATFORM_RESET_ENTRY 0

#endif // CYGONCE_HAL_PLF_STUB_H
