/*
 * structure definitions for Samsung KS32C5000 peripheral registers
 */

typedef volatile unsigned int reg;

#define Bit(n) (1<<(n))


/*
 * Interrupt Controller
 */

typedef struct
{
  reg intmod;          // Interrupt mode register
  reg intpnd;          // Interrupt pending register
  reg intmsk;          // Interrupt mask register
  reg intpri0;         // Interrupt priority register
  reg intpri1;
  reg intpri2;
  reg intpri3;
  reg intpri4;
  reg intpri5;
  reg intoffset;       // Interrupt offset register
} tInterruptController;


/* The following bit masks are for use in the intmod, intpnd, and
 * intmsk registers
 */

#define IntMaskExt0     Bit(0)
#define IntMaskExt1     Bit(1)
#define IntMaskExt2     Bit(2)
#define IntMaskExt3     Bit(3)
#define IntMaskUart0Tx  Bit(4)
#define IntMaskUart0Rx  Bit(5)
#define IntMaskUart0Err Bit(6)
#define IntMaskUart1Tx  Bit(7)
#define IntMaskUart1Rx  Bit(8)
#define IntMaskUart1Err Bit(9)
#define IntMaskDma0     Bit(10)
#define IntMaskDma1     Bit(11)
#define IntMaskTimer0   Bit(12)
#define IntMaskTimer1   Bit(13)
#define IntMaskHDLCA    Bit(14)
#define IntMaskHDLCB    Bit(15)
#define IntMaskEtherBDMATx  Bit(16)
#define IntMaskEtherBDMARx  Bit(17)
#define IntMaskEtherMacTx   Bit(18)
#define IntMaskEtherMacRx   Bit(19)
#define IntMaskI2C      Bit(20)
#define IntMaskGlobal   Bit(21)



/*
 * Timers
 */

typedef struct
{
  reg tmod;      // Timer mode
  reg tdata0;    // Timer 0 Data
  reg tdata1;    // Timer 1 Data
  reg tcnt0;     // Timer 0 Count
  reg tcnt1;     // Timer 1 Count
}tTimers;

#define TimerModeEnable0  Bit(0)
#define TimerModeToggle0  Bit(1)
#define TimerModeInitOut0 Bit(2)
#define TimerModeEnable1  Bit(3)
#define TimerModeToggle1  Bit(4)
#define TimerModeInitOut1 Bit(5)


/*
 * S3C4510 UART
 */

typedef struct
{
  reg ulcon;   // UART Line Control
  reg ucon;    // UART Control
  reg ustat;   // UART Status
  reg utxbuf;  // UART Tx Buffer
  reg urxbuf;  // UART Rx Buffer
  reg brdiv;   // UART Baud Rate Divisor
  reg brdcnt;  // UART Baud Rate Counter
  reg brdclk;  // UART Baud Rate Clock
}tS3C4510Uart;

/* UART Line Control */

#define  S3C4510UartLineWordLenMask 0x03
#define  S3C4510UartLineWordLen5       0
#define  S3C4510UartLineWordLen6       1
#define  S3C4510UartLineWordLen7       2
#define  S3C4510UartLineWordLen8       3

#define  S3C4510UartLineStopMask    (1 << 2)
#define  S3C4510UartLineStop1       (0 << 2)
#define  S3C4510UartLineStop2       (1 << 2)

#define  S3C4510UartLineParityMask  (0x07 << 3)
#define  S3C4510UartLineParityNone   (0 << 3)
#define  S3C4510UartLineParityOdd    (4 << 3)
#define  S3C4510UartLineParityEven   (5 << 3)
#define  S3C4510UartLineParityMark   (6 << 3)
#define  S3C4510UartLineParitySpace  (7 << 3)

#define  S3C4510UartLineInfraRedEnable Bit(7)


/* UART Control */


#define  S3C4510UartControlRxModeMask      3
#define  S3C4510UartControlRxModeDisabled  0
#define  S3C4510UartControlRxModeInterrupt 1
#define  S3C4510UartControlRxModeDma0      2
#define  S3C4510UartControlRxModeDma1      3

#define  S3C4510UartControlRxStatusIntEnable Bit(2)

#define  S3C4510UartControlTxModeMask      (0x3 <<3)
#define  S3C4510UartControlTxModeDisable   (0 <<3)
#define  S3C4510UartControlTxModeInterrupt (1 <<3)
#define  S3C4510UartControlTxModeDma0      (2 <<3)
#define  S3C4510UartControlTxModeDma1      (3 <<3)

#define  S3C4510UartControlDSR             Bit(5)

#define  S3C4510UartControlSendBreak       Bit(6)

#define  S3C4510UartControlLoopback        Bit(7)


/* UART Status */

#define  S3C4510UartStatusRxOverrunError  Bit(0)
#define  S3C4510UartStatusRxParityError   Bit(1)
#define  S3C4510UartStatusRxFrameError    Bit(2)
#define  S3C4510UartStatusRxBreak         Bit(3)
#define  S3C4510UartStatusDTR             Bit(4)
#define  S3C4510UartStatusRxDataAvail     Bit(5)
#define  S3C4510UartStatusTxBufEmpty      Bit(6)
#define  S3C4510UartStatusTxDone          Bit(7)



/*
 * S3C4530 UART
 */

typedef struct
{
  reg ucon;    // UART Control
  reg ustat;   // UART Status
  reg inten;   // UART Interupt enable
  reg utxbuf;  // UART Tx Buffer
  reg urxbuf;  // UART Rx Buffer
  reg brdiv;   // UART Baud Rate Divisor
  reg conchar1;// UART Control Chars
  reg conchar2;//UART Control Chars
}tS3C4530Uart;

// UART Control Register

#define S3C4530UartControlTxModeMask  0x3
#define S3C4530UartControlTxModeDis   0x0
#define S3C4530UartControlTxModeInt   0x1
#define S3C4530UartControlTxModeGDMA0 0x2
#define S3C4530UartControlTxModeGDMA1 0x3

#define S3C4530UartControlRxModeMask  (0x3<<2)
#define S3C4530UartControlRxModeDis   (0x0<<2)
#define S3C4530UartControlRxModeInt   (0x1<<2)
#define S3C4530UartControlRxModeGDMA0 (0x2<<2)
#define S3C4530UartControlRxModeGDMA1 (0x3<<2)

#define S3C4530UartControlSendBreak   Bit(4)
#define S3C4530UartControlClockExt    Bit(5)
#define S3C4530UartControlAutoBaud    Bit(6)
#define S3C4530UartControlLoopback    Bit(7)

#define S3C4530UartControlParityMask  (0x7<<8)
#define S3C4530UartControlParityNone  (0x0<<8)
#define S3C4530UartControlParityOdd   (0x4<<8)
#define S3c4530UartControlParityEven  (0x5<<8)
#define S3C4530UartControlParityMark  (0x6<<8)
#define S3C4530UartControlParitySpace (0x7<<8)

#define S3C4530UartControlStop2       Bit(11)

#define S3C4530UartControlWordLenMask (0x3<<12)
#define S3C4530UartControlWordLen5    (0x0<<12)
#define S3C4530UartControlWordLen6    (0x1<<12)
#define S3C4530UartControlWordLen7    (0x2<<12)
#define S3C4530UartControlWordLen8    (0x3<<12)

#define S3C4530UartControlEnableIR    Bit(14)
#define S3C4530UartControlTxFifoEn    Bit(16)
#define S3C4530UartControlRxFifoEn    Bit(17)
#define S3C4530UartControlTxFifoRst   Bit(18)
#define S3C4530UartControlRxFifoRst   Bit(19)

#define S3C4530UartControlTxFifoTrigMask (0x3<<20)
#define S3C4530UartControlTxFifoTrig1    (0x0<<20)
#define S3C4530UartControlTxFifoTrig8    (0x1<<20)
#define S3C4530UartControlTxFifoTrig18   (0x2<<20)
#define S3C4530UartControlTxFifoTrig28   (0x3<<20)

#define S3C4530UartControlRxFifoTrigMask (0x3<<22)
#define S3C4530UartControlRxFifoTrig1    (0x0<<22)
#define S3C4530UartControlRxFifoTrig8    (0x1<<22)
#define S3C4530UartControlRxFifoTrig18   (0x2<<22)
#define S3C4530UartControlRxFifoTrig28   (0x3<<22)

#define S3C4530UartControlDTR         Bit(24)
#define S3C4530UartControlRTS         Bit(25)

#define S3C4530UartControlHwFlowEn    Bit(28)
#define S3C4530UartControlSwFlowEn    Bit(29)

// Uart Status

#define  S3C4530UartStatusRxDataAvail     Bit(0)
#define  S3C4530UartStatusRxBreak         Bit(1)
#define  S3C4530UartStatusRxFrameError    Bit(2)
#define  S3C4530UartStatusRxParityError   Bit(3)
#define  S3C4530UartStatusRxOverrunError  Bit(4)
#define  S3C4530UartStatusCntrlCharDet    Bit(5)
#define  S3C4530UartStatusDCD             Bit(6)
#define  S3C4530UartStatusRxFifoTrig      Bit(7)
#define  S3C4530UartStatusRxFifoEmpty     Bit(8)
#define  S3C4530UartStatusRxFifoFull      Bit(9)
#define  S3C4530UartStatusRxFifoOverrun   Bit(10)
#define  S3C4530UartStatusRxIdle          Bit(11)
#define  S3C4530UartStatusRxTimeout       Bit(12)

#define  S3C4530UartStatusDSR             Bit(14)
#define  S3C4530UartStatusCTS             Bit(15)

#define  S3C4530UartStatusCTSEvent        Bit(16)
#define  S3C4530UartStatusTxComplete      Bit(17)
#define  S3C4530UartStatusTxHoldRegEmpty  Bit(18)

#define  S3C4530UartStatusTxFifoEmpty     Bit(19)
#define  S3C4530UartStatusTxFifoFull      Bit(20)

// Interrupt Enable

#define  S3C4530UartIntEnaRxData     Bit(0)
#define  S3C4530UartIntEnaBreak      Bit(1)
#define  S3C4530UartIntEnaFrameErr   Bit(2)
#define  S3C4530UartIntEnaParityErr  Bit(3)
#define  S3C4530UartIntEnaOverrun    Bit(4)
#define  S3C4530UartIntEnaCtrlChar   Bit(5)
#define  S3C4530UartIntEnaDCD        Bit(6)
#define  S3C4530UartIntEnaRxFifoTrig Bit(7)
#define  S3C4530UartIntEnaRxFifoOver Bit(10)
#define  S3C4530UartIntEnaTxTimeout  Bit(12)
#define  S3C4530UartIntEnaCTS        Bit(16)
#define  S3C4530UartIntEnaTxEmpty    Bit(18)


    
// macros for external timing control registers

#define Tcos0(n) (((n)&7)<<0)
#define Tacs0(n) (((n)&7)<<3)
#define Tcoh0(n) (((n)&7)<<6)
#define Tacc0(n) (((n)&7)<<9)

#define Tcos1(n) (((n)&7)<<16)
#define Tacs1(n) (((n)&7)<<19)
#define Tcoh1(n) (((n)&7)<<22)
#define Tacc1(n) (((n)&7)<<25)
    
#define Tcos2(n) (((n)&7)<<0)
#define Tacs2(n) (((n)&7)<<3)
#define Tcoh2(n) (((n)&7)<<6)
#define Tacc2(n) (((n)&7)<<9)

#define Tcos3(n) (((n)&7)<<16)
#define Tacs3(n) (((n)&7)<<19)
#define Tcoh3(n) (((n)&7)<<22)
#define Tacc3(n) (((n)&7)<<25)
