#ifndef RPSH2_HAL_PLATFORM_SETUP_H
#define RPSH2_HAL_PLATFORM_SETUP_H
 
#define PLATFORM_SETUP1                                   \
        ldr     r0,=0x7ff0000                            ;\
        ldr     r2,[r0]                                  ;\
        bic     r2,r2,#0x3f                              ;\
        orr     r2,r2,#0x20                              ;\
        str     r2,[r0]       /* disable cache */        ;\
                                                         ;\
	ldr	r1,=0x00000000                           ;\
        ldr     r2,=0xffffffff                           ;\
                                                         ;\
	ldr	r0,=0x07ff6000                           ;\
	str	r1,[r0]        /* disable timers */      ;\
                                                         ;\
	ldr	r0,=0x07ff4000                           ;\
	str	r1,[r0,#0]     /* all ints IRQ mode */   ;\
	str	r2,[r0,#8]     /* mask all interrupts */ ;\
  	str	r2,[r0,#4]     /* ack all interrupts  */ ;\
                                                         ;\
        ldr     r0,=0x07ff9000                           ;\
        str     r1,[r0,#0]     /* shut off BDMA Rx */    ;\
        str     r1,[r0,#4]     /* shut off BDMA Tx */    ;\
                                                         ;\
        ldr     r0,=0x07ffa000                           ;\
        str     r1,[r0,#8]     /* MAC Tx off        */   ;\
        str     r1,[r0,#16]    /* MAC Rx off        */   ;\
        str     r1,[r0,#0]     /* reset MAC control */   
#endif
